// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.util;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
import java.io.Reader;
import org.xml.sax.InputSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.w3c.dom.Document;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ErrorHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;

public class XMLUtil
{
    private static final boolean debug = false;
    private DocumentBuilder parser;
    
    public XMLUtil() {
        this(false, false);
    }
    
    public XMLUtil(final boolean validating, final boolean namespaceAware) {
        final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceAware);
        try {
            (this.parser = factory.newDocumentBuilder()).setErrorHandler(new ErrorHandler() {
                public void fatalError(final SAXParseException e) throws SAXException {
                    System.out.println("fatalError");
                    e.printStackTrace();
                    throw e;
                }
                
                public void error(final SAXParseException e) throws SAXParseException {
                    System.out.println("error");
                    e.printStackTrace();
                    throw e;
                }
                
                public void warning(final SAXParseException e) throws SAXParseException {
                    System.out.println("warning");
                    e.printStackTrace();
                    System.out.println("** Warning, line" + e.getLineNumber() + ", uri " + e.getSystemId());
                    System.out.println(" " + e.getMessage());
                }
            });
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace(System.err);
        }
    }
    
    public Document newDocument() {
        return this.parser.newDocument();
    }
    
    public Document parse(final String uri) throws SAXException, IOException {
        final URL url = new URL(uri);
        HttpURLConnection con = null;
        int responseCode = 0;
        do {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "OAIHarvester/1.1");
            try {
                responseCode = con.getResponseCode();
            }
            catch (FileNotFoundException e) {
                responseCode = 503;
            }
            if (responseCode == 503) {
                long retrySeconds = con.getHeaderFieldInt("Retry-After", -1);
                if (retrySeconds == -1L) {
                    final long now = new Date().getTime();
                    final long retryDate = con.getHeaderFieldDate("Retry-After", now);
                    retrySeconds = retryDate - now;
                }
                if (retrySeconds == 0L) {
                    throw new FileNotFoundException("Bad URL?");
                }
                System.err.println("Server response: Retry-After=" + retrySeconds);
                if (retrySeconds <= 0L) {
                    continue;
                }
                try {
                    Thread.sleep(retrySeconds * 1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        } while (responseCode == 503);
        final InputStream is = con.getInputStream();
        return this.parser.parse(is);
    }
    
    public Document parse(final InputSource s) throws SAXException, IOException {
        return this.parser.parse(s);
    }
    
    public Document parse(final InputStream s) throws SAXException, IOException {
        return this.parser.parse(s);
    }
    
    public Document parse(final Reader r) throws SAXException, IOException {
        final InputSource is = new InputSource(r);
        return this.parser.parse(is);
    }
    
    public static Element getElement(final Document doc, final String tagName) {
        return getElement(doc.getDocumentElement(), tagName);
    }
    
    public static Element getElement(final Document doc, final String tagName, final int index) {
        return getElement(doc.getDocumentElement(), tagName, index);
    }
    
    public static Element getElement(final Element el, final String tagName) {
        return getElement(el, tagName, 0);
    }
    
    public static Element getElement(final Element el, final String tagName, final int index) {
        final NodeList list = el.getElementsByTagName(tagName);
        return (Element)list.item(index);
    }
    
    public static Element getElementNS(final Element el, final String nameSpaceURI, final String tagName) {
        return getElementNS(el, nameSpaceURI, tagName, 0);
    }
    
    public static Element getElementNS(final Element el, final String nameSpaceURI, final String tagName, final int index) {
        final NodeList list = el.getElementsByTagNameNS(nameSpaceURI, tagName);
        return (Element)list.item(index);
    }
    
    public static int getSize(final Document doc, final String tagName) {
        return getSize(doc.getDocumentElement(), tagName);
    }
    
    public static int getSize(final Element el, final String tagName) {
        final NodeList list = el.getElementsByTagName(tagName);
        return list.getLength();
    }
    
    public static int getSizeNS(final Element el, final String nameSpaceURI, final String tagName) {
        final NodeList list = el.getElementsByTagNameNS(nameSpaceURI, tagName);
        return list.getLength();
    }
    
    public static String getValue(final Document doc, final String tagName) {
        return getValue(doc.getDocumentElement(), tagName);
    }
    
    public static String getValue(final Element el, final String tagName) {
        return getValue(el, tagName, 0);
    }
    
    public static String getValue(final Element el, final String tagName, final int index) {
        return getValue(getElement(el, tagName, index));
    }
    
    public static String getValue(final Element el) {
        if (el != null) {
            final NodeList nodes = el.getChildNodes();
            final StringBuffer sb = new StringBuffer();
            for (int length = nodes.getLength(), i = 0; i < length; ++i) {
                final Node node = nodes.item(i);
                String s = null;
                s = node.getNodeValue();
                if (s != null) {
                    sb.append(s.trim());
                }
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }
    
    public static final void main(final String[] args) {
        // 
        // This method could not be decompiled.
        // 
        // Original Bytecode:
        // 
        //     3: dup            
        //     4: aload_0         /* args */
        //     5: iconst_0       
        //     6: aaload         
        //     7: invokespecial   java/net/URL.<init>:(Ljava/lang/String;)V
        //    10: astore_1        /* url */
        //    11: aload_1         /* url */
        //    12: invokevirtual   java/net/URL.openConnection:()Ljava/net/URLConnection;
        //    15: checkcast       Ljava/net/HttpURLConnection;
        //    18: astore_2        /* conn */
        //    19: aload_2         /* conn */
        //    20: iconst_0       
        //    21: invokevirtual   java/net/HttpURLConnection.setUseCaches:(Z)V
        //    24: aload_2         /* conn */
        //    25: invokevirtual   java/net/HttpURLConnection.getInputStream:()Ljava/io/InputStream;
        //    28: astore_3        /* is */
        //    29: new             Ljava/io/InputStreamReader;
        //    32: dup            
        //    33: aload_3         /* is */
        //    34: invokespecial   java/io/InputStreamReader.<init>:(Ljava/io/InputStream;)V
        //    37: astore          isr
        //    39: new             Ljava/io/BufferedReader;
        //    42: dup            
        //    43: aload           isr
        //    45: invokespecial   java/io/BufferedReader.<init>:(Ljava/io/Reader;)V
        //    48: astore          br
        //    50: goto            61
        //    53: getstatic       java/lang/System.out:Ljava/io/PrintStream;
        //    56: aload           6
        //    58: invokevirtual   java/io/PrintStream.println:(Ljava/lang/String;)V
        //    61: aload           br
        //    63: invokevirtual   java/io/BufferedReader.readLine:()Ljava/lang/String;
        //    66: dup            
        //    67: astore          buffer
        //    69: ifnonnull       53
        //    72: goto            83
        //    75: astore_1        /* e */
        //    76: aload_1         /* e */
        //    77: invokevirtual   java/lang/Exception.printStackTrace:()V
        //    80: goto            83
        //    83: return         
        //    Exceptions:
        //  Try           Handler
        //  Start  End    Start  End    Type                 
        //  -----  -----  -----  -----  ---------------------
        //  0      72     75     83     Ljava/lang/Exception;
        // 
        // The error that occurred was:
        // 
        // java.lang.NullPointerException
        //     at com.strobel.decompiler.ast.AstBuilder.convertLocalVariables(AstBuilder.java:2895)
        //     at com.strobel.decompiler.ast.AstBuilder.performStackAnalysis(AstBuilder.java:2445)
        //     at com.strobel.decompiler.ast.AstBuilder.build(AstBuilder.java:108)
        //     at com.strobel.decompiler.languages.java.ast.AstMethodBodyBuilder.createMethodBody(AstMethodBodyBuilder.java:211)
        //     at com.strobel.decompiler.languages.java.ast.AstMethodBodyBuilder.createMethodBody(AstMethodBodyBuilder.java:99)
        //     at com.strobel.decompiler.languages.java.ast.AstBuilder.createMethodBody(AstBuilder.java:782)
        //     at com.strobel.decompiler.languages.java.ast.AstBuilder.createMethod(AstBuilder.java:675)
        //     at com.strobel.decompiler.languages.java.ast.AstBuilder.addTypeMembers(AstBuilder.java:552)
        //     at com.strobel.decompiler.languages.java.ast.AstBuilder.createTypeCore(AstBuilder.java:519)
        //     at com.strobel.decompiler.languages.java.ast.AstBuilder.createTypeNoCache(AstBuilder.java:161)
        //     at com.strobel.decompiler.languages.java.ast.AstBuilder.createType(AstBuilder.java:150)
        //     at com.strobel.decompiler.languages.java.ast.AstBuilder.addType(AstBuilder.java:125)
        //     at com.strobel.decompiler.languages.java.JavaLanguage.buildAst(JavaLanguage.java:71)
        //     at com.strobel.decompiler.languages.java.JavaLanguage.decompileType(JavaLanguage.java:59)
        //     at com.strobel.decompiler.DecompilerDriver.decompileType(DecompilerDriver.java:330)
        //     at com.strobel.decompiler.DecompilerDriver.decompileJar(DecompilerDriver.java:251)
        //     at com.strobel.decompiler.DecompilerDriver.main(DecompilerDriver.java:126)
        // 
        throw new IllegalStateException("An error occurred while decompiling this method.");
    }
}
